/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.network.node;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.apiimpl.network.node.NetworkNode;
import com.refinedmods.refinedstorage.block.CrafterManagerBlock;
import com.refinedmods.refinedstorage.block.NetworkNodeBlock;
import com.refinedmods.refinedstorage.blockentity.CrafterManagerBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class CrafterManagerNetworkNode
extends NetworkNode {
    public static final ResourceLocation ID = new ResourceLocation("refinedstorage", "crafter_manager");
    private static final String NBT_SIZE = "Size";
    private static final String NBT_SEARCH_BOX_MODE = "SearchBoxMode";
    private int size = 0;
    private int searchBoxMode = 0;

    public CrafterManagerNetworkNode(Level level, BlockPos pos) {
        super(level, pos);
    }

    @Override
    public int getEnergyUsage() {
        return RS.SERVER_CONFIG.getCrafterManager().getUsage();
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    public int getSize() {
        return this.level.f_46443_ ? CrafterManagerBlockEntity.SIZE.getValue() : this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    @Override
    public CompoundTag writeConfiguration(CompoundTag tag) {
        super.writeConfiguration(tag);
        tag.m_128405_(NBT_SIZE, this.size);
        tag.m_128405_(NBT_SEARCH_BOX_MODE, this.searchBoxMode);
        return tag;
    }

    @Override
    public void readConfiguration(CompoundTag tag) {
        super.readConfiguration(tag);
        if (tag.m_128441_(NBT_SIZE)) {
            this.size = tag.m_128451_(NBT_SIZE);
        }
        if (tag.m_128441_(NBT_SEARCH_BOX_MODE)) {
            this.searchBoxMode = tag.m_128451_(NBT_SEARCH_BOX_MODE);
        }
    }

    public int getSearchBoxMode() {
        return this.level.f_46443_ ? CrafterManagerBlockEntity.SEARCH_BOX_MODE.getValue() : this.searchBoxMode;
    }

    public void setSearchBoxMode(int searchBoxMode) {
        this.searchBoxMode = searchBoxMode;
    }

    public boolean isActiveOnClient() {
        BlockState state = this.level.m_8055_(this.pos);
        if (state.m_60734_() instanceof CrafterManagerBlock) {
            return (Boolean)state.m_61143_((Property)NetworkNodeBlock.CONNECTED);
        }
        return false;
    }
}

